﻿using System;
using System.Collections.Generic;
using System.Web.Security.AntiXss;
using System.Web.UI.WebControls;

using VIRP;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabResultsInterpretation : EfrBasePage
    {
        private int OrderType;

        private readonly LabResultsInterpretationManager labResultsInterpretationManager;

        public LabResultsInterpretation()
        {
            labResultsInterpretationManager = new LabResultsInterpretationManager();
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            int orderType = GetOrderType();

            labResultsInterpretationManager.RemoveAllLettersFromPrintQueue(CurrentUser, CurrentRegistryId);

            if (orderType == (int)WorkflowCaseActivityStatus.New)
            {
                SetLetterBatchPrintingVisible(true);
                List<INTERPRETATION_LETTER> allLettersInQueueFrag = labResultsInterpretationManager.GetAllInterpretationLettersInPrintQueue(
                    CurrentUser, CurrentRegistryId, (int)EfrWorkCaseType.FragmentAnalysis);

                List<INTERPRETATION_LETTER> allLettersInQueueBio = labResultsInterpretationManager.GetAllInterpretationLettersInPrintQueue(
                    CurrentUser, CurrentRegistryId, (int)EfrWorkCaseType.BiologicalMonitoring);

                LETTER_BATCH_PRINTING_STATUS batchPrintStatus = labResultsInterpretationManager.GetBatchPrintingStatus(
                    CurrentUser, CurrentRegistryId);

                if (allLettersInQueueFrag.Count > 0)
                {
                    if (batchPrintStatus != null)
                    {
                        ButtonPrintLettersPatientFrag.Enabled = !batchPrintStatus.PATIENT_FRAGMENT_BATCH_PRINTED;
                        ButtonPrintLettersProviderFrag.Enabled = !batchPrintStatus.PROVIDER_FRAGMENT_BATCH_PRINTED;
                    }
                    else
                    {
                        ButtonPrintLettersPatientFrag.Enabled = true;
                        ButtonPrintLettersProviderFrag.Enabled = true;
                    }
                }
                else
                {
                    ButtonPrintLettersPatientFrag.Enabled = false;
                    ButtonPrintLettersProviderFrag.Enabled = false;
                }

                if (allLettersInQueueBio.Count > 0)
                {
                    if (batchPrintStatus != null)
                    {
                        ButtonPrintLettersPatientBio.Enabled = !batchPrintStatus.PATIENT_BIO_BATCH_PRINTED;
                        ButtonPrintLettersProviderBio.Enabled = !batchPrintStatus.PROVIDER_BIO_BATCH_PRINTED;
                    }
                    else
                    {
                        ButtonPrintLettersPatientBio.Enabled = true;
                        ButtonPrintLettersProviderBio.Enabled = true;
                    }
                }
                else
                {
                    ButtonPrintLettersPatientBio.Enabled = false;
                    ButtonPrintLettersProviderBio.Enabled = false;
                }
            }
            else
            {
                SetLetterBatchPrintingVisible(false);
            }
            if (!IsPostBack)
            {
                ReplacePageTitle("My Tasks > Interpretation & Follow Up > " + Enum.GetName(typeof(WorkflowCaseActivityStatus), orderType).AddSpacesToCamelCase());
                HiddenFieldClearFlag.Value = "0";
            }

            SetupCommonDataSourceParameters();
        }

        private void SetupCommonDataSourceParameters()
        {
            ObjectDataSourceInterpretationActivities.SelectParameters["CURRENT_USER"].DefaultValue = CurrentUser;
            ObjectDataSourceInterpretationActivities.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = CurrentRegistryId.ToString();
        }

        private void SetLetterBatchPrintingVisible(bool visible)
        {
            ButtonPrintLettersPatientBio.Visible = visible;
            ButtonPrintLettersPatientFrag.Visible = visible;
            ButtonPrintLettersProviderBio.Visible = visible;
            ButtonPrintLettersProviderFrag.Visible = visible;
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxSearchCriteria.Text = String.Empty;
            HiddenFieldClearFlag.Value = "1";
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewLabResultsInterpretation.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";
        }
        
        protected void ObjectDataSourceInterpretationActivities_Selected(object sender, ObjectDataSourceStatusEventArgs e)
        {
            GridViewLabResultsInterpretation.EmptyDataText = "No records found for the " 
                + Enum.GetName(typeof(WorkflowCaseActivityStatus), GetOrderType()).AddSpacesToCamelCase() + " lab interpretation results.";
        }

        private int GetOrderType()
        {
            if (!IsPostBack)
            {
                OrderType = Convert.ToInt16(AntiXssEncoder.HtmlEncode(Request.QueryString["OrderType"], false));
                ViewState["OrderType"] = OrderType;
            }
            else //For paging
                OrderType = Convert.ToInt16(ViewState["OrderType"]);
            return OrderType;
        }

        protected void SelectActivity(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewLabResultsInterpretation.SelectedIndex = index;
                int CaseId = Convert.ToInt32(GridViewLabResultsInterpretation.SelectedDataKey.Values[0]);
                int WfType = Convert.ToInt16(GridViewLabResultsInterpretation.SelectedDataKey.Values[1]);

                if (WfType == Convert.ToInt16(WorkFlowTypes.Biomonitoring))
                    Response.Redirect(string.Format("~/Custom/EFR/InterpretationAndFollowUp/BioLabInterpretation.aspx?CaseId={0}", CaseId), false);

                if (WfType == Convert.ToInt16(WorkFlowTypes.FragmentAnalysis))
                    Response.Redirect(string.Format("~/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretation.aspx?CaseId={0}", CaseId), false);
            }
        }

        protected void ButtonPrintLettersProviderBio_Click(object sender, EventArgs e)
        {
            UpdateBatchPrintingStatus(LetterType.ProviderBioMonitoring);
            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=12&CaseId=0"));
        }

        protected void ButtonPrintLettersPatientBio_Click(object sender, EventArgs e)
        {
            UpdateBatchPrintingStatus(LetterType.PatientBioMonitoring);
            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=11&CaseId=0"));
        }

        protected void ButtonPrintLettersProviderFrag_Click(object sender, EventArgs e)
        {
            UpdateBatchPrintingStatus(LetterType.ProviderFragment);
            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=14&CaseId=0"));
        }

        protected void ButtonPrintLettersPatientFrag_Click(object sender, EventArgs e)
        {
            UpdateBatchPrintingStatus(LetterType.PatientFragment);
            Response.Redirect(string.Format("LabResultsInterpretationLetters.aspx?activityId=0&intActivityId=0&RptType=13&CaseId=0"));
        }

        private void UpdateBatchPrintingStatus(LetterType letterType)
        {
            labResultsInterpretationManager.UpdateLetterBatchPrintingStatus(CurrentUser, CurrentRegistryId, letterType);
        }
    }
}